<?php

App::uses('Controller', 'Controller');

class AppController extends Controller
{
    public $uses = array('Activity');
    public $layout = 'frontend';
    public $components = array(
        'Flash',
        'Security',
        'Session',
        'Email',
        'Auth' => array(
            'loginAction' => array('controller' => 'users', 'action' => 'login', 'members' => 1),
            //'loginRedirect' => array('controller' => 'users', 'action' => 'dashboard', 'members' => 1),
            'logoutRedirect' => array('controller' => 'users', 'action' => 'login', 'members' => 1),
            'authenticate' => array(
                'Form' => array(
                    'passwordHasher' => 'Blowfish'
                )
            ),
            'authorize' => array('Controller')
        )
    );

    public function beforeFilter()
    {
        if (Configure::read('debug') == 2) {
            $this->Toolbar = $this->Components->load('DebugKit.Toolbar');
        }

        if (isset_recaptcha()) {
            $this->Recaptcha = $this->Components->load('Recaptcha');
        }

        $this->set('website_title', Configure::read('Option.site_name'));
        $this->set('website_description', Configure::read('Option.site_description'));

        if ($this->request->is(array('post', 'put'))) {
            if ($this->Auth->user('account_type') == 'Demo') {
                $this->Flash->set(__('This request is disabled into demo.'), array(
                    'element' => 'error'
                ));
                return $this->redirect($this->referer());
            }
        }
    }

    public function isAuthorized($user)
    {
        // Any user can access none prefix functions
        if (empty($this->request->params['prefix'])) {
            return true;
        }

        // Only admins can access all functions
        if (isset($user['account_type']) && in_array($user['account_type'], array('Admin', 'Demo'))) {
            return true;
        }

        // Free users can access members functions
        if ($this->request->params['prefix'] === 'members') {
            return (bool) ($user['account_type'] === 'Free');
        }

        // Default deny
        return false;
    }
}
